/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.cec;

import com.quantumdata.cec.CECComplianceCDF;
import com.quantumdata.ftp.CoFile;
import com.quantumdata.ftp.Ftp;
import com.quantumdata.ftp.FtpConnect;
import com.quantumdata.ftp.FtpFile;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.std.SocketConnection;
import com.quantumdata.widgets.QDButton;
import com.quantumdata.widgets.QDCheckBox;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CECComplianceMain
extends QDPanel
implements ActionListener,
ChangeListener {
    private static QDCheckBox[] m_checkBoxes;
    private static QDLabel[] m_resultLabels;
    private JTabbedPane m_mainTabs;
    private CECComplianceCDF cdfPanel;
    private QDPanel testPanel;
    private QDButton runTests;
    private QDButton selectAllTests;
    private QDButton deselectAllTests;
    private QDButton abortTests;
    private QDLabel currentTestName;
    private JScrollPane scroller;
    private RemoteInstrument instrument;
    private FtpConnect ftpCon = new FtpConnect();
    private Ftp ftpClient = new Ftp();
    private String m_fileName = "";
    private boolean m_abortFlag;
    public static final Font m_checkBoxFont;
    private static final String[] m_configDrawingNames;
    private static final String[] m_testNames;

    public CECComplianceMain() {
        int n;
        GridBagLayout gridBagLayout = new GridBagLayout();
        m_checkBoxes = new QDCheckBox[m_testNames.length];
        m_resultLabels = new QDLabel[m_testNames.length];
        this.testPanel = new QDPanel(gridBagLayout);
        this.cdfPanel = new CECComplianceCDF(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        this.runTests = new QDButton("Run Selected Tests");
        this.runTests.addActionListener(this);
        this.selectAllTests = new QDButton("Select All Tests");
        this.selectAllTests.addActionListener(this);
        this.deselectAllTests = new QDButton("Deselect All Tests");
        this.deselectAllTests.addActionListener(this);
        this.abortTests = new QDButton("Abort Testing");
        this.abortTests.addActionListener(this);
        for (n = 0; n < m_testNames.length; ++n) {
            CECComplianceMain.m_checkBoxes[n] = new QDCheckBox(m_testNames[n]);
            m_checkBoxes[n].setFont(m_checkBoxFont);
            CECComplianceMain.m_resultLabels[n] = new QDLabel("NOT TESTED");
            m_resultLabels[n].setForeground(Color.CYAN);
        }
        for (n = 0; n < m_testNames.length; ++n) {
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            this.testPanel.add((Component)m_checkBoxes[n], gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.testPanel.add((Component)m_resultLabels[n], gridBagConstraints);
        }
        this.scroller = new JScrollPane(this.testPanel, 22, 30);
        Dimension dimension = new Dimension(900, 760);
        this.scroller.setMaximumSize(dimension);
        this.scroller.setMinimumSize(dimension);
        this.scroller.setPreferredSize(dimension);
        QDPanel qDPanel = new QDPanel(gridBagLayout);
        QDPanel qDPanel2 = new QDPanel(gridBagLayout);
        QDPanel qDPanel3 = new QDPanel(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        qDPanel3.add((Component)new QDLabel("Current test: "), gridBagConstraints);
        qDPanel2.add((Component)this.runTests, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        qDPanel2.add((Component)this.selectAllTests, gridBagConstraints);
        this.currentTestName = new QDLabel("None");
        qDPanel3.add((Component)this.currentTestName, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        qDPanel2.add((Component)this.deselectAllTests, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        qDPanel2.add((Component)this.abortTests, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        qDPanel.add((Component)qDPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        qDPanel.add((Component)this.scroller, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        qDPanel.add((Component)qDPanel3, gridBagConstraints);
        this.m_mainTabs = new JTabbedPane();
        this.m_mainTabs.addTab("CDF", this.cdfPanel);
        this.m_mainTabs.addTab("Tests", qDPanel);
        this.m_mainTabs.addChangeListener(this);
        this.add(this.m_mainTabs);
    }

    public void SetInstrument(RemoteInstrument remoteInstrument) {
        this.instrument = remoteInstrument;
    }

    public void clearResults() {
        for (int i = 0; i < m_resultLabels.length; ++i) {
            m_resultLabels[i].setText("NOT TESTED");
            m_resultLabels[i].setForeground(Color.CYAN);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.runTests) {
            this.clearResults();
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    CECComplianceMain.this.RunTests(CECComplianceMain.this.instrument);
                }
            });
            thread.start();
        } else if (actionEvent.getSource() == this.selectAllTests) {
            for (int i = 0; i < m_checkBoxes.length; ++i) {
                m_checkBoxes[i].setSelected(true);
            }
        } else if (actionEvent.getSource() == this.deselectAllTests) {
            for (int i = 0; i < m_checkBoxes.length; ++i) {
                m_checkBoxes[i].setSelected(false);
            }
        } else if (actionEvent.getSource() == this.abortTests) {
            this.m_abortFlag = true;
            InstrumentResponse instrumentResponse = this.instrument.sendCmd("CECX:CECT:CLR");
            while (this.instrument.sendCmd("CECX:CECT:CECU?").getResponse().equalsIgnoreCase("1")) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            this.currentTestName.setText("None");
        }
    }

    void RunTests(RemoteInstrument remoteInstrument) {
        InstrumentResponse instrumentResponse = remoteInstrument.sendCmd("CECX:CECT:CLR");
        this.m_abortFlag = false;
        this.runTests.setEnabled(false);
        this.selectAllTests.setEnabled(false);
        this.deselectAllTests.setEnabled(false);
        for (int i = 0; i < m_checkBoxes.length; ++i) {
            m_checkBoxes[i].setEnabled(false);
        }
        while (remoteInstrument.sendCmd("CECX:CECT:CECU?").getResponse().equalsIgnoreCase("1")) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        boolean bl = false;
        for (int i = 0; i < m_testNames.length; ++i) {
            if (!m_checkBoxes[i].isSelected()) continue;
            bl = true;
            String string = m_testNames[i].replace(' ', '_');
            instrumentResponse = remoteInstrument.sendCmd("CECX:CECT:ADD " + string);
        }
        if (!bl) {
            JOptionPane.showMessageDialog(this, "No tests are selected.");
            return;
        }
        instrumentResponse = remoteInstrument.sendCmd("CECX:CECT:CECU");
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl2 = true;
        while (bl2) {
            Object object;
            Object object2;
            instrumentResponse = remoteInstrument.sendCmd("CECX:CECT:CECU?");
            bl2 = instrumentResponse.getResponse().equals("1");
            String string = remoteInstrument.sendCmd("CECX:CECT:NAME?").getResponse();
            string = string.replace('_', ' ');
            this.currentTestName.setText(string);
            instrumentResponse = remoteInstrument.sendCmd("CECX:CECT:STAT?");
            String string2 = instrumentResponse.getResponse();
            boolean bl3 = true;
            if (string2.equals("2")) {
                boolean bl4 = false;
                object2 = remoteInstrument.sendCmd("CECX:CECT:RSLT?").getResponse();
                if (((String)object2).equals("0")) {
                    object2 = "NOT TESTED";
                    object = Color.MAGENTA;
                    bl3 = false;
                } else if (((String)object2).equals("1")) {
                    object2 = "PASS";
                    object = Color.GREEN;
                    bl3 = false;
                } else if (((String)object2).equals("2")) {
                    object2 = "FAIL";
                    object = Color.RED;
                } else {
                    object2 = "NOT JUDGED";
                    object = Color.ORANGE;
                    bl4 = true;
                }
                int n = 1;
                if (bl4) {
                    n = JOptionPane.showConfirmDialog(this, "Error occurred during test.  Would you like to retry?", "Retry?", 0);
                } else if (bl3) {
                    n = JOptionPane.showConfirmDialog(this, "Test did not pass.  Would you like to retry?", "Retry?", 0);
                }
                if (n == 0) {
                    remoteInstrument.sendCmd("CECX:CECT:STAT 7");
                } else {
                    remoteInstrument.sendCmd("CECX:CECT:STAT 1");
                }
                string = string.replace('_', ' ');
                for (int i = 0; i < m_testNames.length; ++i) {
                    if (!string.equalsIgnoreCase(m_testNames[i])) continue;
                    m_resultLabels[i].setText((String)object2);
                    m_resultLabels[i].setForeground((Color)object);
                    this.testPanel.scrollRectToVisible(m_resultLabels[i].getBounds());
                }
                continue;
            }
            if (string2.equals("3")) {
                String string3 = "<HTML>" + remoteInstrument.sendCmd("CECX:CECT:DESC?").getResponse() + "</HTML>";
                object2 = new Object[]{"OK"};
                object = new JOptionPane(string3, -1, 0, null, (Object[])object2);
                JDialog jDialog = ((JOptionPane)object).createDialog(this, "Tester Information");
                jDialog.setVisible(true);
                remoteInstrument.sendCmd("CECX:CECT:STAT 1");
                continue;
            }
            if (string2.equals("4")) {
                boolean bl5 = true;
                object2 = "";
                while (bl5) {
                    object2 = JOptionPane.showInputDialog(this, (Object)("<HTML>" + remoteInstrument.sendCmd("CECX:CECT:DESC?").getResponse() + "</HTML>"));
                    try {
                        if (Double.isNaN(Double.parseDouble((String)object2))) {
                            bl5 = true;
                            continue;
                        }
                        bl5 = false;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl5 = true;
                    }
                }
                remoteInstrument.sendCmd("CECX:CECT:VALU " + (String)object2);
                continue;
            }
            if (string2.equals("5")) {
                int n = JOptionPane.showConfirmDialog(this, "<HTML>" + remoteInstrument.sendCmd("CECX:CECT:DESC?").getResponse() + "</HTML>", "Please answer.", 0);
                if (n == 0) {
                    remoteInstrument.sendCmd("CECX:CECT:VALU 1");
                    continue;
                }
                remoteInstrument.sendCmd("CECX:CECT:VALU 0");
                continue;
            }
            if (!string2.equals("8")) continue;
            instrumentResponse = remoteInstrument.sendCmd("CECX:CECT:CNFG?");
            int n = m_configDrawingNames.length;
            if (!instrumentResponse.isError()) {
                n = Integer.parseInt(instrumentResponse.getResponse());
            }
            object2 = "";
            if (n < m_configDrawingNames.length) {
                object2 = m_configDrawingNames[n];
            }
            object = "<HTML>" + remoteInstrument.sendCmd("CECX:CECT:DESC?").getResponse() + "</HTML>";
            Object[] objectArray = new Object[]{object, ((String)object2).length() > 0 ? new JLabel(new ImageIcon(CECComplianceMain.class.getResource("resources/" + (String)object2))) : ""};
            Object[] objectArray2 = new Object[]{"OK"};
            JOptionPane jOptionPane = new JOptionPane(objectArray, -1, 0, null, objectArray2);
            JDialog jDialog = jOptionPane.createDialog(this, "Configuration Diagram");
            jDialog.setVisible(true);
            remoteInstrument.sendCmd("CECX:CECT:STAT 1");
        }
        this.runTests.setEnabled(true);
        this.selectAllTests.setEnabled(true);
        this.deselectAllTests.setEnabled(true);
        for (int i = 0; i < m_checkBoxes.length; ++i) {
            m_checkBoxes[i].setEnabled(true);
        }
        if (this.m_abortFlag) {
            JOptionPane.showMessageDialog(this, "Testing aborted.");
            this.m_abortFlag = false;
        } else {
            JOptionPane.showMessageDialog(this, "Testing complete.");
        }
        this.currentTestName.setText("None");
    }

    public static boolean ParseRange(String string, boolean[] blArray, int n, int n2) {
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = false;
        }
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            int n3;
            stringArray[i] = stringArray[i].trim();
            if (stringArray[i].length() == 0) continue;
            int n4 = stringArray[i].indexOf(45);
            if (n4 != -1) {
                n3 = Integer.parseInt(stringArray[i].substring(0, n4).replace('x', '0'), 16);
                int n5 = Integer.parseInt(stringArray[i].substring(n4 + 1, stringArray[i].length()).replace('x', '0'), 16);
                if (n3 < n || n5 > n2) {
                    return false;
                }
                for (int j = n3; j <= n5; ++j) {
                    blArray[j - n] = true;
                }
                continue;
            }
            n3 = Integer.parseInt(stringArray[i].replace('x', '0'), 16);
            if (n3 < n || n3 > n2) {
                return false;
            }
            blArray[n3 - n] = true;
        }
        return true;
    }

    public void LoadCDF() {
        if (!this.ConnectToFTP()) {
            JOptionPane.showMessageDialog(this, "Could not connect to unit.");
            return;
        }
        Object[] objectArray = this.GetFTPDirectoryListing();
        if (objectArray.length == 0) {
            JOptionPane.showMessageDialog(this, "No CDFs to load.");
            this.DisconnectFromFTP();
            return;
        }
        String string = (String)JOptionPane.showInputDialog(this, "Choose file to be opened from 882:", "Open file from 882", 3, null, objectArray, objectArray[0]);
        if (string != null && string.length() > 0) {
            try {
                if (this.ftpClient.pwd() != "/tffs0/Library/CEC/CDF/" && !this.ftpClient.cd("/tffs0/Library/CEC/CDF/")) {
                    JOptionPane.showMessageDialog(this, "<HTML>Could not load CDF:<br>Directory was not accessible.</HTML>");
                }
                FtpFile ftpFile = new FtpFile(string, this.ftpClient);
                this.cdfPanel.GetCDFEntries(ftpFile.copyToLocalFile("tmp.xml"));
                this.m_fileName = string;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.DisconnectFromFTP();
    }

    public void UseCDF(int n) {
        if (this.m_fileName.length() < 3) {
            JOptionPane.showMessageDialog(this, "<HTML>You cannot use a CDF without<br>loading or saving it first.</HTML>");
        } else {
            int n2 = JOptionPane.showConfirmDialog(this, "<HTML>The file '" + this.m_fileName + "' will be used<br>as it was when it was last loaded<br>" + "or saved.  If you have made changes,<br>please save before using.<br>Would you like to continue?</HTML>", "Is this okay?", 0);
            if (n2 == 0) {
                InstrumentResponse instrumentResponse = this.instrument.sendCmd("CECX:CECT:CDFL " + this.m_fileName.substring(0, this.m_fileName.length() - 4));
                if (instrumentResponse.isError()) {
                    System.out.println(instrumentResponse.getResponse());
                }
                if ((instrumentResponse = this.instrument.sendCmd("CECX:CECT:DEVS " + n)).isError()) {
                    System.out.println(instrumentResponse.getResponse());
                }
                if ((instrumentResponse = this.instrument.sendCmd("UUTL " + CECComplianceCDF.uutTypes[n] + "; UUTU")).isError()) {
                    System.out.println(instrumentResponse.getResponse());
                }
                if ((instrumentResponse = this.instrument.sendCmd("CECX:CECT:CDFU")).isError()) {
                    System.out.println(instrumentResponse.getResponse());
                } else {
                    int n3;
                    String string = "";
                    for (n3 = 0; n3 < m_testNames.length; ++n3) {
                        m_checkBoxes[n3].setSelected(false);
                    }
                    n3 = 0;
                    while (n3 == 0) {
                        instrumentResponse = this.instrument.sendCmd("CECX:CECT:CDFU?");
                        if (instrumentResponse.isError()) {
                            System.out.println(instrumentResponse.getResponse());
                        }
                        if ((n3 = (int)((string = instrumentResponse.getResponse()).equalsIgnoreCase("N/A") ? 1 : 0)) != 0) continue;
                        this.setCheckBoxes(string.replace('_', ' '));
                    }
                    this.clearResults();
                }
            }
        }
    }

    private void setCheckBoxes(String string) {
        for (int i = 0; i < m_testNames.length; ++i) {
            if (!string.equalsIgnoreCase(m_testNames[i])) continue;
            m_checkBoxes[i].setSelected(true);
            return;
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    private boolean ConnectToFTP() {
        SocketConnection socketConnection = (SocketConnection)this.instrument.getConnection();
        this.ftpCon.setHostName(socketConnection.getHostName());
        this.ftpCon.setPassWord("");
        this.ftpCon.setUserName("");
        boolean bl = true;
        try {
            bl = this.ftpClient.connect(this.ftpCon);
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl && !this.ftpClient.cd("/tffs0/Library/CEC/CDF/")) {
            if (!this.ftpClient.mkdir("/tffs0/Library/CEC/CDF/")) {
                JOptionPane.showMessageDialog(this, "<HTML>Directory could not be made.</HTML>");
                this.DisconnectFromFTP();
                return false;
            }
            if (!this.ftpClient.cd("/tffs0/Library/CEC/CDF/")) {
                JOptionPane.showMessageDialog(this, "<HTML>Could not load CDF:<br>Directory could not be made.</HTML>");
                this.DisconnectFromFTP();
                return false;
            }
        }
        return bl;
    }

    public String[] GetFTPDirectoryListing() {
        String[] stringArray = null;
        boolean bl = this.ftpClient.isConnected();
        if (!bl && !this.ConnectToFTP()) {
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            return stringArray;
        }
        FtpFile ftpFile = new FtpFile(".", this.ftpClient);
        if (ftpFile.isDirectory()) {
            CoFile[] coFileArray = ftpFile.listCoFiles();
            stringArray = new String[coFileArray.length];
            for (int i = 0; i < coFileArray.length; ++i) {
                stringArray[i] = coFileArray[i].getName();
            }
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if (!bl) {
            this.DisconnectFromFTP();
        }
        return stringArray;
    }

    public void CopyFileToFTP(String string, File file) {
        boolean bl;
        boolean bl2 = this.ftpClient.isConnected();
        if (!bl2 && !this.ConnectToFTP()) {
            JOptionPane.showMessageDialog(this, "<HTML>Could not connect to unit.</HTML>");
            return;
        }
        String[] stringArray = this.GetFTPDirectoryListing();
        do {
            int n;
            bl = false;
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].equalsIgnoreCase(string)) continue;
                bl = true;
            }
            if (!bl) continue;
            n = 0;
            int n2 = JOptionPane.showConfirmDialog(this, "<HTML>The filename provided already exists.<br>Would you like to overwrite?</HTML>", "Overwrite?", 0);
            if (n2 == 1) {
                do {
                    String string2;
                    if (!(string = JOptionPane.showInputDialog(this, (Object)"Please provide a filename (without extension).")).equalsIgnoreCase(string2 = CECComplianceCDF.fixName(string))) {
                        n2 = JOptionPane.showConfirmDialog(this, "<HTML>The filename provided is not valid.<br>Is <b>" + string2 + "</b> acceptable?</HTML>", "Is this okay?", 0);
                        if (n2 != 0) continue;
                        string = string2;
                        n = 1;
                        continue;
                    }
                    n = 1;
                } while (n == 0);
                string = string + ".xml";
                continue;
            }
            bl = false;
        } while (bl);
        FtpFile ftpFile = new FtpFile(string, this.ftpClient);
        this.m_fileName = string;
        try {
            ftpFile.saveToFtpFile(file);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        if (!bl2) {
            this.DisconnectFromFTP();
        }
    }

    private void DisconnectFromFTP() {
        this.ftpClient.disconnect();
    }

    static {
        m_checkBoxFont = new Font("SansSerif", 1, 12);
        m_configDrawingNames = new String[]{"", "CECT7p1Sink.gif", "CECT7p1Source.gif", "CECTPA4R.gif", "CECTPA4R.gif", "CECTPA4x.gif"};
        m_testNames = new String[]{"7-1 [Sink]", "7-1 [Source]", "7-1 [Switch-Sink]", "7-1 [Switch-Source]", "7-2 [Sink]", "7-2 [Source]", "7-2 [Switch-Sink]", "7-2 [Switch-Source]", "8.1", "8.1 [Switch]", "8.2-1", "8.2-2", "8.2-3", "8.2-4", "8.2-5", "8.2-6", "8.2-1 [Switch]", "8.2-2 [Switch]", "8.2-3 [Switch]", "8.2-4 [Switch]", "8.2-5 [Switch]", "8.2-6 [Switch]", "9.1-1", "9.1-2", "9.1-3", "9.2-1", "9.2-2", "9.2-2 [Switch]", "9.3-1", "9.3-2", "9.3-3", "9.3-4", "9.3-3 [Switch]", "9.3-4 [Switch]", "9.4-1 [Routing Change]", "9.4-1 [Routing Information]", "9.4-1 [Set Stream Path]", "9.4-1 [Give Deck Status]", "9.4-1 [Play]", "9.4-1 [Give Tuner Device Status]", "9.4-1 [Select Digital Service]", "9.4-1 [Vendor Command]", "9.4-1 [Vendor Remote Button Down]", "9.4-1 [User Control Pressed]", "9.4-1 [Set OSD Name]", "9.4-1 [Set OSD String]", "9.4-1 [Report Power Status]", "9.4-1 [Active Source]", "9.4-1 [Record Status]", "9.4-1 [Set Menu Language]", "9.4-1 [Deck Control]", "9.4-1 [Deck Status]", "9.4-1 [Tuner Device Status]", "9.4-1 [Device Vendor ID]", "9.4-1 [Menu Request]", "9.4-1 [Menu Status]", "9.4-1 [Feature Abort]", "9.4-1 [Report Physical Address]", "9.4-1 [Record On-Own Source]", "9.4-1 [Record On-Digital Service]", "9.4-1 [Record On-Analogue Service]", "9.4-1 [Record On-External Plug]", "9.4-1 [Record On-External PA]", "9.4-1 [Inactive Source]", "9.4-1 [Clear Analogue Timer]", "9.4-1 [Set Analogue Timer]", "9.4-1 [Clear Digital Timer]", "9.4-1 [Set Digital Timer]", "9.4-1 [Clear External Timer]", "9.4-1 [Set External Timer]", "9.4-1 [Set Timer Program Title]", "9.4-1 [Timer Cleared Status]", "9.4-1 [Timer Status]", "9.4-1 [CEC Version]", "9.4-1 [Select Analogue Service]", "9.4-1 [Vendor Command With ID]", "9.4-1 [Report Audio Status]", "9.4-1 [Set System Audio Mode]", "9.4-1 [System Audio Mode Request]", "9.4-1 [System Audio Mode Status]", "9.4-1 [Set Audio Rate]", "9.5-1", "9.5-1 [Switch]", "9.6-1", "9.6-2", "9.6-1 [Switch]", "9.6-2 [Switch]", "9.7-1", "9.7-1 [Switch]", "9.7-2", "10.1.1.1-1", "10.1.1.2-1", "10.1.2-1", "10.1.2-2", "10.2.1.1-1", "10.2.1.2-1", "10.2.2-1", "10.2.2-2", "10.2.2-3", "10.2.3-1", "10.2.3-2", "10.2.3-3", "10.2.4-1", "10.2.4-2", "10.2.4-3", "10.2.4-4", "10.2.5-1", "11.1.1-1", "11.1.1-2", "11.1.1-3", "11.1.1-4", "11.1.1-5", "11.1.1-6", "11.1.1-7", "11.2.1-1", "11.2.1-2", "11.1.2-1", "11.1.2-2", "11.1.2-3", "11.1.2-4", "11.1.2-5", "11.2.2-1", "11.2.2-2", "11.2.2-3", "11.2.2-4", "11.1.3-1", "11.1.3-2", "11.1.3-3", "11.2.3-1", "11.2.3-2", "11.2.3-3", "11.1.4-1", "11.1.4-2", "11.1.4-3", "11.1.4-4", "11.1.4-5", "11.1.4-6", "11.1.4-7", "11.1.4-8", "11.1.4-9", "11.1.4-10", "11.1.4-11", "11.1.4-12", "11.1.4-13", "11.2.4-1", "11.2.4-2", "11.2.4-3", "11.2.4-4", "11.2.4-5", "11.2.4-6", "11.2.4-7", "11.2.4-8", "11.2.4-9 [Own Source]", "11.2.4-9 [Digital Service]", "11.2.4-9 [Analogue Service]", "11.2.4-9 [External Plug]", "11.2.4-9 [External PA]", "11.2.4-10", "11.1.5-1", "11.1.5-2", "11.1.5-3", "11.1.5-4", "11.1.5-5", "11.1.5-6", "11.1.5-7", "11.1.5-8", "11.1.5-9", "11.1.5-10", "11.1.5-11", "11.1.5-12", "11.1.5-13", "11.1.5-14", "11.1.5-15", "11.1.5-16", "11.2.5-1", "11.2.5-2", "11.2.5-3", "11.2.5-4", "11.2.5-5", "11.2.5-6", "11.2.5-7", "11.2.5-8", "11.2.5-9", "11.2.5-10", "11.2.5-11", "11.2.5-12", "11.2.5-13", "11.2.5-14", "11.2.5-15", "11.2.5-16", "11.2.5-17", "11.2.5-18", "11.2.5-19 [External Plug]", "11.2.5-19 [External PA]", "11.2.5-20", "11.2.5-21", "11.2.5-22 [External Plug]", "11.2.5-22 [External PA]", "11.1.6-1", "11.1.6-2", "11.1.6-3", "11.1.6-4", "11.1.6-5", "11.1.6-6", "11.2.6-1", "11.2.6-2", "11.2.6-3", "11.2.6-4", "11.2.6-5", "11.2.6-6", "11.1.7-1", "11.1.7-2", "11.1.7-3", "11.2.7-1", "11.2.7-2", "11.2.7-3", "11.2.7-4", "11.2.7-5", "11.2.7-6", "11.2.7-7", "11.2.7-8", "11.2.7-9", "11.2.7-10 [Fast Forward Min Speed]", "11.2.7-10 [Fast Forward Medium Speed]", "11.2.7-10 [Fast Forward Max Speed]", "11.2.7-10 [Fast Reverse Min Speed]", "11.2.7-10 [Fast Reverse Medium Speed]", "11.2.7-10 [Fast Reverse Max Speed]", "11.2.7-10 [Slow Forward Min Speed]", "11.2.7-10 [Slow Forward Medium Speed]", "11.2.7-10 [Slow Forward Max Speed]", "11.2.7-10 [Slow Reverse Min Speed]", "11.2.7-10 [Slow Reverse Medium Speed]", "11.2.7-10 [Slow Reverse Max Speed]", "11.2.7-11 [Fast Forward Min Speed]", "11.2.7-11 [Fast Forward Medium Speed]", "11.2.7-11 [Fast Forward Max Speed]", "11.2.7-11 [Fast Reverse Min Speed]", "11.2.7-11 [Fast Reverse Medium Speed]", "11.2.7-11 [Fast Reverse Max Speed]", "11.2.7-11 [Slow Forward Min Speed]", "11.2.7-11 [Slow Forward Medium Speed]", "11.2.7-11 [Slow Forward Max Speed]", "11.2.7-11 [Slow Reverse Min Speed]", "11.2.7-11 [Slow Reverse Medium Speed]", "11.2.7-11 [Slow Reverse Max Speed]", "11.2.7-12", "11.2.7-13", "11.2.7-14 [Part 1]", "11.2.7-14 [Part 2]", "11.2.7-14 [Part 3]", "11.2.7-14 [Part 4]", "11.2.7-14 [Part 5]", "11.2.7-14 [Part 6]", "11.2.7-14 [Part 7]", "11.2.7-14 [Part 8]", "11.2.7-14 [Part 9]", "11.2.7-14 [Part 10]", "11.2.7-14 [Part 11]", "11.2.7-14 [Part 12]", "11.2.7-14 [Part 13]", "11.2.7-14 [Part 14]", "11.2.7-15", "11.2.7-16", "11.2.7-17", "11.1.8-1", "11.1.8-2", "11.1.8-3", "11.2.8-1", "11.2.8-2", "11.2.8-3", "11.2.8-4", "11.2.8-5", "11.2.8-6", "11.2.8-7", "11.2.8-8", "11.2.8-9", "11.2.8-10", "11.2.8-11", "11.2.8-12", "11.2.8-13", "11.1.9-1", "11.1.9-2", "11.2.9-1", "11.2.9-2", "11.2.9-3", "11.1.10-1", "11.1.10-2", "11.1.10-3", "11.2.10-1", "11.1.11-1", "11.1.11-2", "11.2.11-1", "11.2.11-2", "11.1.12-1", "11.1.12-2", "11.1.12-3", "11.1.12-4", "11.1.12-5", "11.1.12-6", "11.1.12-7", "11.2.12-1", "11.2.12-2", "11.2.12-3", "11.2.12-4", "11.2.12-5", "11.2.12-6", "11.2.12-7", "11.1.13-1", "11.1.13-2", "11.1.13-3", "11.1.13-4", "11.1.13-5 [Recording Device]", "11.1.13-5 [Tuner]", "11.1.13-5 [Player]", "11.2.13-1", "11.1.14-1", "11.1.14-2", "11.2.14-1", "11.2.14-2", "11.1.15-1", "11.1.15-2", "11.1.15-3", "11.1.15-4", "11.1.15-5", "11.2.15-1", "11.2.15-2", "11.2.15-3", "11.2.15-4", "11.2.15-5", "11.2.15-6", "11.2.15-7", "11.2.15-8", "11.2.15-9", "11.2.15-10", "11.2.15-11", "11.2.15-12", "11.1.16-1", "11.2.16-1", "11.3.1-1", "11.3.1-2", "11.3.1-3", "11.3.1-4", "11.3.1-5", "11.3.1-6", "11.3.2-1", "12-1 [Active Source]", "12-1 [Request Active Source]", "12-1 [Routing Change]", "12-1 [Routing Information]", "12-1 [Set Stream Path]", "12-1 [Set Menu Language]", "12-1 [Device Vendor ID]", "12-1 [Report Physical Address]", "12-2 [Image View On]", "12-2 [Text View On]", "12-2 [Record Off]", "12-2 [Record Status]", "12-2 [Record TV Screen]", "12-2 [Give Physical Address]", "12-2 [Deck Control]", "12-2 [Deck Status]", "12-2 [Give Deck Status]", "12-2 [Play]", "12-2 [Select Digital Service]", "12-2 [Select Analogue Service]", "12-2 [Tuner Device Status]", "12-2 [Tuner Step Increment]", "12-2 [Tuner Step Decrement]", "12-2 [Give Device Vendor ID]", "12-2 [Set OSD String]", "12-2 [Give OSD Name]", "12-2 [Set OSD Name]", "12-2 [Menu Request]", "12-2 [Menu Status]", "12-2 [User Control Pressed]", "12-2 [User Control Released]", "12-2 [Give Device Power Status]", "12-2 [Report Device Power Status]", "12-2 [Feature Abort]", "12-2 [Get Menu Language]", "12-2 [Give Tuner Device Status]", "12-2 [Abort]", "12-2 [Vendor Command]", "12-2 [Inactive Source]", "12-2 [Timer Cleared Status]", "12-2 [Timer Status]", "12-2 [CEC Version]", "12-2 [Get CEC Version]", "12-2 [Give Audio Status]", "12-2 [Give System Audio Mode Status]", "12-2 [Report Audio Status]", "12-2 [System Audio Mode Request]", "12-2 [System Audio Mode Status]", "12-2 [Set Audio Rate]", "12-2 [Set Digital Timer]", "12-2 [Set Analogue Timer]", "12-2 [Set External Timer (Plug)]", "12-2 [Set External Timer (PA)]", "12-2 [Clear Digital Timer]", "12-2 [Clear Analogue Timer]", "12-2 [Clear External Timer (Plug)]", "12-2 [Clear External Timer (PA)]", "12-2 [Record On-Own Source]", "12-2 [Record On-Digital Service]", "12-2 [Record On-Analogue]", "12-2 [Record On-External Plug]", "12-2 [Record On-External PA]", "12-2 [Set Timer Program Title]", "12-3 [Active Source]", "12-3 [Request Active Source]", "12-3 [Routing Change]", "12-3 [Routing Information]", "12-3 [Set Stream Path]", "12-3 [Set Menu Language]", "12-3 [Device Vendor ID]", "12-3 [Report Physical Address]", "12-3 [Set System Audio Mode]"};
    }
}

